/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define ITERS 50
#define M_PI 3.1415926535897932384626433832795

void main( void )
{
  vec2 p = vec2(gl_FragCoord.x / iResolution.x,
                gl_FragCoord.y / iResolution.y);
  float z = fract(0.02 * iGlobalTime);
  int acc = 0;
  float trig = (cos(2. * M_PI * z) + 1.) / 2.;
  float a = mix(1., 3.75, trig) + p.x * mix(3., 0.25, trig);
  
  for (int i = 0; i < ITERS; i++) {
    acc += (z > p.y && z <= p.y + 1. / iResolution.y) ? 1 : 0;
    z = a * z * (1.-z);
  }
  float iters = float(ITERS);
  float g = 25. * float(acc) / iters;

  gl_FragColor = vec4(g, g /3., g / 8.,1.);

}
